package gov.va.vinci.dart.db;

import javax.persistence.Query;

import gov.va.vinci.dart.biz.RequestSummary;
import gov.va.vinci.dart.db.util.NativeQueryDAO;

public class RequestTrackingNumberDAO extends NativeQueryDAO<RequestSummary> {

	private String trackingNumber;
	
	public RequestTrackingNumberDAO(final String trackingNumber) {
		this.trackingNumber = trackingNumber;
	}
	
	public String getQueryText() {
		return "select r.id"+
				", r.activityId"+
				", r.name"+
				", r.trackingNumber"+
				", r.updatedOn"+
				" from hib.request r"+
				" where r.trackingNumber like ?"+
				" order by r.id";
	}
	
	public void populateParameters(final Query q) {
		q.setParameter(1, "%"+trackingNumber+"%"); 
	}

	public RequestSummary buildResult(final Object obj) {
		RequestSummary summary = new RequestSummary();

		if (obj.getClass().isArray()) {
			Object[] two = (Object[]) obj;
			
			summary.setRequestId((Integer)two[0]);
			summary.setActivityId((Integer)two[1]);
			summary.setActivityName((String)two[2]);
			summary.setTrackingNumber((String)two[3]);
			summary.setUpdatedOn((java.sql.Timestamp)two[4]);

			return summary;
		}
		else {
			throw new IllegalStateException("Cannot parse JDBC query result");
		}

	}
}
